 ; Ŀ
 ;   Miss - missile program.                                               
 ;   Copyright 1996, 2000 by Rocket Software                               
 ;   Empty cruise missiles are usually not returned for the $5 deposit.    
 ; 

 ; Ŀ
 ;   Redefine the explode command.                                         
 ; 
  (defun c:explode () (c:miss))
  (command "undefine" "explode")
 ; Ŀ
 ;   End of Redefine area.                                                 
 ; 

 ; Ŀ
 ;   Miserr - error handler.                                               
 ; 
 (DEFUN MISERR (shk /)
  (setq *error* esav)
  (cond ((= shk "bad argument type")
         (write-line "\nUnable to acquire target."))
        ((/= shk "Function cancelled")
         (write-line shk)))
 (princ))
 ; Ŀ
 ;   Miserr end.                                                           
 ; 

 ; Ŀ
 ;   Ccr - draw a set of radial lines.                                     
 ;   Reps = lines in 360, Divs = explosion/screen height, Pa = centre.     
 ; 
 (DEFUN CCR (pa reps divs / colo rad rad2 angg incr)
  (setq colo -1)
  (setq rad (/ (getvar "viewsize") divs))
  (setq rad2 (/ rad 2))
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (grdraw (polar pa angg rad2) (polar pa angg rad) colo)
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Ccr end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Farcrn - find the corner of the screen furthest away from  
 ;   a selected point.                                                     
 ; 
 (DEFUN FARCRN (pa / pax pay a vs ctr w maxx minx maxy miny pfar)
  (setq pax (car pa))
  (setq pay (cadr pa))
  (setq a (getvar "screensize"))           ; view height & width (pixels)
  (setq a (/ (car a) (cadr a)))            ; view width/height ratio
  (setq vs (* (getvar "viewsize") 0.5))    ; view height in drawing units
  (setq ctr (getvar "viewctr"))            ; centre point of screen
  (setq w (* vs a ))                       ; view half width
  (setq maxx (+ (car ctr) w))
  (setq minx (- (car ctr) w))
  (setq maxy (+ (cadr ctr) vs))
  (setq miny (- (cadr ctr) vs))
  (if (> (- maxx pax) (- pax minx))
      (if (> (- maxy pay) (- pay miny))
          (setq pfar (list maxx maxy))
          (setq pfar (list maxx miny)))
      (if (> (- maxy pay) (- pay miny))
          (setq pfar (list minx maxy))
          (setq pfar (list minx miny))))
 pfar)
 ; Ŀ
 ;   Farcrn end.                                                           
 ; 

 ; Ŀ
 ;   Miss - draw a missile.                                                
 ;   Each set of points must be adjusted for offset from pa (add x and y   
 ;   of pa to x and y of points), for scale (multiply each coordinate by   
 ;   scale) and for rotation. Each point is specified as a distance and a  
 ;   rotation. Rotation is relative to internal base point, so rotate      
 ;   first, scale also, so scale second, and then add basepoint to move    
 ;   scaled and rotated assembly.                                          
 ; 
 (DEFUN MISS (pa ang scal / pax pay linlst curlst p0 num sub dist1 ang1 p1)
  (setq pax (car pa))
  (setq pay (cadr pa))
  (setq linlst (list "lines1" "lines2" "lines3" "lines4" "lines5"))
  (while (and linlst (setq curlst (eval (read (setq clis (car linlst))))))
         (setq linlst (cdr linlst))
         (setq p0 ())
         (setq num 0)
         (while (setq sub (nth num curlst))
                (setq dist1 (* scal (car sub)))
                (setq ang1 (+ (cadr sub) ang))
                (setq p1 (polar '(0 0) ang1 dist1))
                (setq p1 (list (+ (car p1) pax) (+ (cadr p1) pay)))
                (if (and p1 p0)
                    (grdraw p1 p0 -1))
                (setq p0 p1)
                (setq num (1+ num)))))
 ; Ŀ
 ;   Miss end.                                                             
 ; 

 ; Ŀ
 ;   Exh - draw a missile exhaust.                                         
 ; 
 (DEFUN EXH (pa ang scal / pax pay linlst curlst p0 num sub dist1 ang1 p1)
  (setq pax (car pa))
  (setq pay (cadr pa))
  (setq p0 ())
  (setq num 0)
  (while (setq sub (nth num lines5))
         (setq dist1 (* scal (car sub)))
         (setq ang1 (+ (cadr sub) ang))
         (setq p1 (polar '(0 0) ang1 dist1))
         (setq p1 (list (+ (car p1) pax) (+ (cadr p1) pay)))
         (if (and p1 p0)
             (grdraw p1 p0 1))
         (setq p0 p1)
         (setq num (1+ num)))
 ; Ŀ
 ;   Putting Princ on the end of a subroutine seems to force the screen    
 ;   to display the grdraw lines which were just created, otherwise they   
 ;   will all be displayed when the routine is finished, which is          
 ;   typically not a good idea for animation.                              
 ; 
 (princ))
 ; Ŀ
 ;   Exh end.                                                              
 ; 

 ; Ŀ
 ;   Miss - the final event.                                               
 ; 
 (DEFUN C:MISS (/ esav enampt pa enam lines1 lines2 lines3 lines4 lines5 scal
                                                                 incr pb angg)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq esav *error*)
  (setq *error* miserr)
  (setq enampt (entsel "Entity to explode: "))
  (setq pa (cadr enampt))
  (setq enam (car enampt))
 ; Ŀ
 ;   Set up lists of distances and angles for missile line endpoints.      
 ; 
  (setq lines1 (list '(0.0 0.0) '(3.162278 3.46334) '(12.041595 3.224734)))
  (setq lines2 (list '(12.041595 3.058451) '(3.162278 2.819842) '(0.0 0.0)))
  (setq lines3 (list '(9.055385 3.252250) '(10.198039 3.338988)
                     '(12.165525 3.306741) '(12.165525 2.976444)
                     '(10.198039 2.944197) '(9.055385 3.030935)))
  (setq lines4 (list '(12.000000 3.141593) '(9.000000 3.141593)))
  (setq lines5 (list '(12.595 3.224734) '(12.595 3.058451)))
 ; Ŀ
 ;   Get scale to draw missile at based on screen height.                  
 ; 
  (setq scal (* (getvar "viewsize") 0.015))
 ; Ŀ
 ;   And set movement increment to half of that in drawing units.          
 ; 
  (setq incr (/ scal 10))
 ; Ŀ
 ;   Find the furthest corner of the screen from the pick point.           
 ; 
  (setq pbsav (setq pb (farcrn pa)))
 ; Ŀ
 ;   Find the angle for the missile.                                       
 ; 
  (setq angg (angle pb pa))
 ; Ŀ
 ;   Now draw the incoming missile.                                        
 ; 
  (while (> (distance pa pb) incr)
         (setq pb (polar pb angg incr))
         (miss pb angg scal)      ; draw
         (exh pb angg scal)       ; draw exhaust
         (miss pb angg scal))     ; undraw
 ; Ŀ
 ;   Try to explode the entity.                                            
 ; 
  (command ".explode" enam)
 ; Ŀ
 ;   If it couldn't be exploded then cancel the command and make the       
 ;   missile carry on past the target.                                     
 ; 
  (if (entget enam)
      (progn
           (command)
           (setq dist (distance pbsav pa))
           (setq pa (polar pa angg dist))
           (while (> (distance pa pb) incr)
                  (setq pb (polar pb angg incr))
                  (miss pb angg scal)      ; draw
                  (exh pb angg scal)       ; draw exhaust
                  (miss pb angg scal)))    ; undraw
 ; Ŀ
 ;   Otherwise draw the explosion.                                         
 ; 
      (progn
           (ccr pb 32 10) (ccr pb 32 8) (ccr pb 32 6) (ccr pb 32 4)
           (ccr pb 32 3) (ccr pb 32 10) (ccr pb 24 8) (ccr pb 16 6)
           (ccr pb 8 4) (ccr pb 4 3) (ccr pb 32 10) (ccr pb 32 8)
           (ccr pb 32 6) (ccr pb 32 4) (ccr pb 32 3)))
  (setq *error* esav)
 (princ))